<?php

defined('BASEPATH') OR exit('No direct script access allowed');
class Home extends CI_Controller {

  function __construct(){
    error_reporting(E_ALL & ~E_NOTICE);
        parent::__construct();
        $this->load->helper(array('form', 'url'));
        $this->load->model('home');
        $this->load->library('session');
        $this->session->mark_as_flash('item');
        
  }

      public function index(){
        $this->load->view('login');
      }
      public function dashboard(){
        $this->template->build('dashboard');
      }
      public function login(){
      $data=$_POST;
          if(!empty($data)){
                $admin_user=$this->home->login($data);
                    if(!empty($admin_user)){
                      $userdata = array('user_id'  =>$admin_user['user_id'],
                                       'name'      =>$admin_user['name'],
                                       'location'  =>$admin_user['work_location'],
                                       'login_type' =>$admin_user['login_type'],
                                      );
                     
                        $this->session->set_userdata($userdata);
                        if($this->session->userdata('login_type')=="admin"){
                          
                          redirect('dashboard');
                        }elseif($this->session->userdata('login_type')=="manager"){
                            redirect('user');
                        }else{
                             redirect('billing');
                        }
                        
                        //$this->template->build('register');
                    }else{
                       $result['message']=array('result'=>'failed','page'=>'login','message'=>"invalid username/password");
                       $this->load->view('login',$result);
                    }
              }else{
                redirect('/');
              }
      }

          public function logout(){
              session_destroy();
             redirect('/','refresh');
          }
    

             public function user(){
              $data['case']="view";
              $this->template->build('register',$data);
            }

            public function view_user($id){
            $case="register";
            $data['register']=$this->home->edit_data($id,$case);
            $data['case']="view_user";
            $this->template->build('register',$data);
            }


            public function add_user(){
              $data['case']="add";
              $this->template->build('register',$data);
            }


            public function checkemail(){
              $email=$this->input->get('email');
              $this->db->where('email',trim($email));
              $this->db->from(LOGIN);
              $query = $this->db->get()->row_array();
                  if($query){
                    echo "false";
                  }else{
                    echo "true";
                  }
            }


            public function insert_user(){
              $data=$_POST;
              $case="register";
              $data['created_on']=date('Y-m-d');
              //$data['password']=substr(md5(mt_rand()), 0, 7);
             
              $insert_id=$this->home->add_data($data,$case);
              if (isset($_FILES['profile_image']) && !empty($_FILES['profile_image']['name'])) {

                    if (!file_exists('uploads/profile/'.$insert_id)) {
                        mkdir('uploads/profile/'.$insert_id, 0777, true);
                    }

                    $fileInfo = pathinfo($_FILES['profile_image']['name']);
                    $img_name = rand() . '.' . $fileInfo['extension'];
                    $ImageName = $img_name;
                    $path='uploads/profile/'.$insert_id.'/'.$ImageName;
                    $location = $path; 
                    move_uploaded_file($_FILES['profile_image']['tmp_name'], $location); 
                      $data_imgs['profile_image'] = $ImageName;
                      $data_imgs['user_id'] = $insert_id;
                      $this->home->update_data($data_imgs,$case);
                    }

                      if($insert_id){
                            $result=array('result'=>"success",'message'=>'User added  successfully');
                      }else{
                            $result=array('result'=>"failed",'message'=>"Something went wrong please try after sometime..");
                      }
             $this->session->set_flashdata('message', $result);
             redirect('home/user');
       
        }
           

           public function edit_user($id){
           $case="register";
           $data['register']=$this->home->edit_data($id,$case);
           $data['case']="edit";
           $this->template->build('register',$data);
            }

            public function update_user(){
              $data=$_POST;
              $old_image=$data['old_image'];
              $img = $_POST['profile_image'];
              unset($data['old_image']);
              unset($data['profile_image']);
              
              $checkemail=$this->home->editcheckemail($data);
              if($checkemail){
                  $result=array('result'=>"failed",'message'=>"Email id   name already exits ");
                  $this->session->set_flashdata('message', $result);
                  redirect('home/user');
               }else{
                      $case="register";
                      $update_id=$this->home->update_data($data,$case);
                    

                    if (isset($_FILES['profile_image']) && !empty($_FILES['profile_image']['name'])) {

                       if (!file_exists('uploads/profile/'.$data['user_id'])) {
                        mkdir('uploads/profile/'.$data['user_id'], 0777, true);
                    }
                         unlink('uploads/profile/'.$data['user_id'].'/'.$old_image);
                    $fileInfo = pathinfo($_FILES['profile_image']['name']);
                    $img_name = rand() . '.' . $fileInfo['extension'];
                    $ImageName = $img_name;
                    $path='uploads/profile/'.$data['user_id'].'/'.$ImageName;
                    $location = $path; 
                    move_uploaded_file($_FILES['profile_image']['tmp_name'], $location); 
                      $data_imgs['profile_image'] = $ImageName;
                      $data_imgs['user_id'] = $data['user_id'];
                      $this->home->update_data($data_imgs,$case);
                    }
                    
                 if($update_id){
                      $result=array('result'=>"success",'message'=>'User  Updated  successfully');
                  }else{
                      $result=array('result'=>"failed",'message'=>"Something went wrong please try after sometime..");
                  }
              $this->session->set_flashdata('message', $result);
              redirect('home/user');
            }
        }

        public function delete_user($id){
          $this->db->select('user_id,profile_image');
          $this->db->where('user_id',$id);
          $this->db->from(LOGIN);
          $images=$this->db->get()->row_array();
             unlink('uploads/profile/'.$id.'/'.$images['profile_image']);
             rmdir(DELETEPATH.$id);
             $delete_records=$this->home->delete_record($id);
                if($delete_records){
                    $result=array('result'=>"success",'message'=>"User deleted successfully");
                }else{
                    $result=array('result'=>"failed",'message'=>"Something went wrong please try after sometime..");
                }
           $this->session->set_flashdata('message', $result);
           redirect('home/user');
            }

            //products section

            public function products(){
                $data['case']="view";
                $this->template->build('products',$data);
            }

             public function view_products($id){
                $case="products";
                $data['products']=$this->home->edit_data($id,$case);
                $data['case']="view_products";
                $this->template->build('products',$data);
            }


            public function add_products(){
                $data['case']="add";
                $this->template->build('products',$data);
            }


            public function checkproduct(){
              $product_details=$_POST;
                $this->db->where('product_name',trim($product_details['name']));
                $this->db->where('location', trim($product_details['location']));
                $this->db->from(PRODUCTS);
                $query = $this->db->get()->row_array();
                
                    if($query){
                       $result=array('result'=>"failed",'message'=>"Product Already Exits");
                    }else{
                      $result=array('result'=>"success");
                    }
                    echo json_encode($result);
               
            }


            public function insert_products(){
                $data=$_POST;
                $case="products";
                $insert_id=$this->home->add_data($data,$case);

                      if (isset($_FILES['product_image']) && !empty($_FILES['product_image']['name'])) {
                            
                            $fileInfo = pathinfo($_FILES['product_image']['name']);
                            $img_name = rand() . '.' . $fileInfo['extension'];
                            $ImageName = $img_name;
                            $path='uploads/product_image/'.$ImageName;
                            $location = $path; 
                            move_uploaded_file($_FILES['product_image']['tmp_name'], $location); 
                              $data_imgs['product_image'] = $ImageName;
                              $data_imgs['id'] = $insert_id;
                              $this->home->update_data($data_imgs,$case);
                      }

                        if($insert_id){
                              $result=array('result'=>"success",'message'=>'Products added  successfully');
                        }else{
                              $result=array('result'=>"failed",'message'=>"Something went wrong please try after sometime..");
                        }
             $this->session->set_flashdata('message', $result);
             redirect('home/products');
       
        }
           

           public function edit_products($id){
           $case="products";
           $data['products']=$this->home->edit_data($id,$case);
           $data['case']="edit";
           $this->template->build('products',$data);
            }

            public function update_products(){
              $data=$_POST;
              $old_image=$data['old_product_image'];
              $img = $_POST['product_image'];
              unset($data['old_product_image']);
              unset($data['product_image']);
              
              $checkemail=$this->home->editcheckproducts($data);
              if($checkemail){
                  $result=array('result'=>"failed",'message'=>"Product   name already exits ");
                  $this->session->set_flashdata('message', $result);
                  redirect('home/products');
               }else{
                  $case="products";
                  $update_id=$this->home->update_data($data,$case);
                    

                    if (isset($_FILES['product_image']) && !empty($_FILES['product_image']['name'])) {
                        unlink('uploads/product_image/'.$old_image);
                        $fileInfo = pathinfo($_FILES['profile_image']['name']);
                        $img_name = rand() . '.' . $fileInfo['extension'];
                        $ImageName = $img_name;
                        $path='uploads/product_image/'.$ImageName;
                        $location = $path; 
                        move_uploaded_file($_FILES['product_image']['tmp_name'], $location); 
                        $data_imgs['product_image'] = $ImageName;
                        $data_imgs['id'] = $data['id'];
                        $this->home->update_data($data_imgs,$case);
                    }
                    
                     if($update_id){
                          $result=array('result'=>"success",'message'=>'Product  Updated  successfully');
                      }else{
                          $result=array('result'=>"failed",'message'=>"Something went wrong please try after sometime..");
                      }
              $this->session->set_flashdata('message', $result);
              redirect('home/products');
            }
        }

        public function delete_product($id,$status){
          $this->db->select('id,product_image');
          $this->db->where('id',$id);
          $this->db->from(PRODUCTS);
          $images=$this->db->get()->row_array();
                //unlink('uploads/product_image/'.$images['product_image']);
                
            $data = array(
                'status' => $status
            );
            $this->db->where('id',$id);
            $delete_products= $this->db->update(PRODUCTS, $data);                

                if($delete_products){
                    $result=array('result'=>"success",'message'=>"Product deleted successfully");
                }else{
                    $result=array('result'=>"failed",'message'=>"Something went wrong please try after sometime..");
                }
           $this->session->set_flashdata('message', $result);
           redirect('home/products');
      }


      //Billing section




            public function billing(){
                $data['case']="view";
                $this->template->build('billing',$data);
            }

             public function view_billing(){
                $case="billing";
                $data['case']="view_billing";
                $this->template->build('billing',$data);
             }


             public function weekly_bill($id){
                $case="weekly_bill";
                $datas=$_POST;
                $datas['id']=$id;
                $data['bill_data']=$this->home->edit_data($datas,$case);
                $data['case']="view_billing";
                $data['type']="Weekly Bill Report";
                $data['id']= $id;
                $this->template->build('billing',$data);
             }
              public function month_bill($id='1'){
				$month_number =  date("m") - '1'; 
                $case="weekly_bill";
				$first_day = date("d-m-Y", strtotime("first day of this month"));
                $datas ['start_date'] = $first_day;
                $datas ['end_date'] = date("d-m-Y");
                $datas['id']=$id;
                $data['bill_data']=$this->home->edit_data($datas,$case);
                $data['case']="view_billing";
				$months = array('January','February','March','April','May','June','July','August','September','October','November','December');
                $data['type']= $months[$month_number];
                $this->template->build('billing',$data);
             }

             public function daily_bill($id){
                $case="daily_bill";
                $datas=$_POST;
                $datas['id']=$id;
                $data['bill_data']=$this->home->edit_data($datas,$case);
                $data['type']="Datewise Bill Report";
                $data['case']="view_billing";
                $this->template->build('billing',$data);
             }  


            public function add_billing(){
                $data['case']="add";
                $this->template->build('billing',$data);
            }

            public function insert_billing(){
                $data=$_POST;

              
                $case="billing";
                $explode=explode('^',$data['product_name']);
                $data['product_name']=$explode[0];
                $data['ticket_cost']=$explode[1] * $data['ticket'];
                
                $insert_id=$this->home->add_data($data,$case);
                  
        if($insert_id){
               $this->load->library('pdf');
                $case="printbill";
                $billing=$this->home->edit_data($insert_id,$case);
                
              $html_content="<div class='ibox'>

         <div class='ibox-body ' id='gymusercheet'>
         <div class='row'>
               <div class='col-md-6 '>
                   <p style='color:blue'><label>Product Image</label></p>";
                   $html_content .="<img src=".(PRODUCTPATH.$billing['product_image'])." style='width: 100px;height: 100px;'>
                 </div>
              <div class='col-sm-12 form-group'>
                   <p style='color:blue'><label>Product Name</label></p>";
                   $html_content .= ucwords($billing['product_name'])."
                 </div>
                 
                  <div class='col-sm-12 form-group'>
                    <p style='color:blue'> <label>No Of Ticket</label></p>";
                    $html_content .= ucwords($billing['ticket'])."
                 </div>

                  <div class='col-sm-12 form-group'>
                  <p style='color:blue'><label>Payment Type</label></p>";
                  $html_content .= ucwords($billing['payment_type'])."
                 </div>

                  <div class='col-sm-12 form-group'>
                  <p style='color:blue'><label>Ticket Cost</label></p>";
                  $html_content .= ucwords($billing['ticket_cost'])."
                 </div>

                 <div class='col-sm-12 form-group'>
                  <p style='color:blue'><label>Date</label></p>";
                  $html_content .= date("d-m-Y", strtotime($billing['date']))."
                 </div>

                 <div class='col-sm-12 form-group'>
                  <p style='color:blue'><label>Time</label></p>";
                  $html_content .= strtoupper(date('h:i:s a ', strtotime($billing['time'])))."
                 </div>

             </div>

           </div>

         </div>";

         echo $html_content;
        }else{
           $html_content .="<div class='ibox'>
                   <div class='ibox-body ' id='gymusercheet'>
                   <div class='row'>
                         <div class='col-md-6 '>
                          <div class='col-sm-12 form-group'>
                          <p style='color:blue'><label>Failed</label></p>";
                          $html_content .= ucwords("Oops ! Something went wrong")."
                         </div>
                         </div>
                    </div>
                  </div>";
          echo $html_content;
        }
        }
           

        public function delete_billing($id){
          $this->db->where_in('user_id',$id);
          $delete_billing = $this->db->delete(BILL);
              if($delete_billing){
                  $result=array('result'=>"success",'message'=>"Billing deleted successfully");
              }else{
                  $result=array('result'=>"failed",'message'=>"Something went wrong please try after sometime..");
              }
           $this->session->set_flashdata('message', $result);
           redirect('home/billing');
      }




      //Expence Module

            public function expence(){
                $data['case']="view";
                $this->template->build('expence',$data);
            }

             public function view_expence($id){
                $case="expence";
                $data['case']="view_expence";
                $this->template->build('expence',$data);
            }


            public function add_expence(){
                $data['case']="add";
                $this->template->build('expence',$data);
            }
            



            public function insert_expence(){
                $data=$_POST;
                $case="expence";
                $insert_id=$this->home->add_data($data,$case);
                  if($insert_id){
                    $result=array('result'=>"success",'message'=>'Expence added  successfully');
                  }else{
                        $result=array('result'=>"failed",'message'=>"Something went wrong please try after sometime..");
                  }
             $this->session->set_flashdata('message', $result);
             redirect('home/expence');
       
        }
           
        public function edit_expence($id){
           $case="expence";
           $data['expence_data']=$this->home->edit_data($id,$case);
           $data['case']="edit";
           $this->template->build('expence',$data);
            }


        public function delete_expence($id){
          $this->db->where('id',$id);
          $delete_billing = $this->db->delete(EXPENCE);
              if($delete_billing){
                  $result=array('result'=>"success",'message'=>"Expence deleted successfully");
              }else{
                  $result=array('result'=>"failed",'message'=>"Something went wrong please try after sometime..");
              }
           $this->session->set_flashdata('message', $result);
           redirect('home/expence');
      }




      public function update_expence(){
              $data=$_POST;
               $checkexpence=$this->home->editcheckexpence($data);
              if($checkexpence){
                  $result=array('result'=>"failed",'message'=>"Expence   name already exits ");
                  $this->session->set_flashdata('message', $result);
                  redirect('home/expence');
               }else{
                  $case="expence";
                  $update_id=$this->home->update_data($data,$case);
                       if($update_id){
                            $result=array('result'=>"success",'message'=>'Expence  Updated  successfully');
                        }else{
                            $result=array('result'=>"failed",'message'=>"Something went wrong please try after sometime..");
                        }
              $this->session->set_flashdata('message', $result);
              redirect('home/expence');
            }
        }

        public function checkexpence(){
                $product=$this->input->get('expence_name');
                $this->db->where('expence_name',trim($product));
                $this->db->from(EXPENCE);
                $query = $this->db->get()->row_array();
                      if($query){
                        echo "false";
                      }else{
                        echo "true";
                      }
            }





            //Expence cost  Module

            public function checkexpencecost(){
              $date = date("Y-m-d");
              $expence=$this->input->get('expence_name');
              $this->db->where('expence_name',trim($expence));
              $this->db->where('date',$date);
              $this->db->where('user_id',$this->session->userdata('user_id'));
              $this->db->from(EXPENCE_COST);
              $query = $this->db->get()->row_array();
                  if($query){
                    echo "false";
                  }else{
                    echo "true";
                  }
           
            }

            public function expence_cost(){
                $data['case']="view";
                $this->template->build('expencecost',$data);
            }

            

            public function add_expence_cost(){
                $data['case']="add";
                $this->template->build('expencecost',$data);
            }

            public function insert_expence_cost(){
                $data=$_POST;
                $case="expencecost";
                $insert_id=$this->home->add_data($data,$case);
				
                      if($insert_id){
                        $result=array('result'=>"success",'message'=>'Expence added  successfully');
                      }else{
                            $result=array('result'=>"failed",'message'=>"Something went wrong please try after sometime..");
                      }
             $this->session->set_flashdata('message', $result);
             if($this->session->userdata('login_type')=="admin"){
               redirect('home/admin_expence');
             }else{
               redirect('home/expence_cost');
             }
            
       
        }
           
        public function edit_expence_cost($id){
           $case="expencecost";
           $data['cost_data']=$this->home->edit_data($id,$case);
           $data['case']="edit";
           $this->template->build('expencecost',$data);
            }


        public function delete_expence_cost($id){
            $this->db->where('id',$id);
            $expence_cost = $this->db->delete(EXPENCE_COST);
         
                if($expence_cost){
                    $result=array('result'=>"success",'message'=>"Expence Cost deleted successfully");
                }else{
                    $result=array('result'=>"failed",'message'=>"Something went wrong please try after sometime..");
                }
           $this->session->set_flashdata('message', $result);
                   redirect('home/expence_cost');
      }

      public function view_expence_cost($id){
                $case="expencecost";
                $data['cost_data']=$this->home->edit_data($id,$case);
                $data['case']="view_expence";
                $this->template->build('expencecost',$data);
            }


             public function update_expence_cost(){
                  $data=$_POST;
                  $case="expencecost";
                  $expencecost=$this->home->editexpencecost($data);

             /* if($expencecost){
                  $result=array('result'=>"failed",'message'=>"Expence  already Enter for this category exits ");
                  $this->session->set_flashdata('message', $result);
                  redirect('home/expence_cost');
               }else{*/
                  $update_id=$this->home->update_data($data,$case);
                     if($update_id){
                          $result=array('result'=>"success",'message'=>'Expence  Updated  successfully');
                      }else{
                          $result=array('result'=>"failed",'message'=>"Something went wrong please try after sometime..");
                      }
              $this->session->set_flashdata('message', $result);
            if($this->session->userdata('login_type')=="admin"){
            	if($data['status']=="2"){
            		 redirect('home/admin_expence');
            		}else{
            		redirect('home/expence_adminview');
            		}
              
             }else{
               redirect('home/expence_cost');
             }
            
        
      }




        public function weekly_expence($id){
                $case="weekly_expence";
                $datas=$_POST;
                $datas['user_id']=$id;
                $data['expenceclose_data']=$this->home->edit_data($datas,$case);
                $data['case']="view_expence";
                $data['type']="Weekly Expence Cost  Report";
                $this->template->build('expencecost',$data);
             }


             public function daily_expence($id){
                $case="daily_expence";
                $datas=$_POST;
                $datas['user_id']=$id;
                $data['expenceclose_data']=$this->home->edit_data($datas,$case);
                $data['type']="Datewise Expence Cost Report";
                $data['case']="view_expence";
                $this->template->build('expencecost',$data);
             }  




        //day closing

        public function dayclosing(){
                $data['case']="view";
                $this->template->build('dayclosing',$data);
            }

            

            public function add_dayclosing(){
                $data['case']="add";
                $this->template->build('dayclosing',$data);
            }

            public function insert_dayclosing(){
                $data=$_POST;
                $case="dayclosing";
                $insert_id=$this->home->add_data($data,$case);
                        if($insert_id){
                          $result=array('result'=>"success",'message'=>'Dayclosing added  successfully');
                        }else{
                              $result=array('result'=>"failed",'message'=>"Something went wrong please try after sometime..");
                        }
               
             $this->session->set_flashdata('message', $result);
             redirect('home/dayclosing');
       
        }
           
        public function edit_dayclosing($id){
           $case="dayclosing";
           $data['dayclosing']=$this->home->edit_data($id,$case);
           $data['case']="edit";
           $this->template->build('dayclosing',$data);
            }


        public function delete_dayclosing($id){
            $this->db->where_in('user_id',$id);
            $expence_cost = $this->db->delete(DAYCLOSING);
         
                if($expence_cost){
                    $result=array('result'=>"success",'message'=>"Dayclosing Details deleted successfully");
                }else{
                    $result=array('result'=>"failed",'message'=>"Something went wrong please try after sometime..");
                }
           $this->session->set_flashdata('message', $result);
           redirect('home/dayclosing');
      }

      public function view_dayclosing($id){
                $data['case']="view_dayclosing"; 
                $this->template->build('dayclosing',$data);
            }


      public function update_dayclosing(){
              $data=$_POST;
                  $case="dayclosing";
                  $update_id=$this->home->update_data($data,$case);
                     if($update_id){
                          $result=array('result'=>"success",'message'=>'Dayclosing  Updated  successfully');
                      }else{
                          $result=array('result'=>"failed",'message'=>"Something went wrong please try after sometime..");
                      }
              $this->session->set_flashdata('message', $result);
              redirect('home/dayclose_edit');
            
        }


        public function weekly_dayclose($id){
                $case="weekly_dayclose";
                $datas=$_POST;
                $datas['user_id']=$id;
                $data['dayclose_data']=$this->home->edit_data($datas,$case);
                $data['case']="view_dayclosing";
                $data['type']="Weekly Dayclosing Report";
                $this->template->build('dayclosing',$data);
             }
        public function current_month_dayclose($id){
                $case="weekly_dayclose";
                $month_number =  date("m") - '1'; 
                $case="weekly_bill";
				$first_day = date("d-m-Y", strtotime("first day of this month"));
                $datas ['start_date'] = $first_day;
                $datas ['end_date'] = date("d-m-Y");
                $datas['id']=$id;
                $data['dayclose_data']=$this->home->edit_data($datas,$case);
                $data['case']="view_dayclosing";
                $months = array('January','February','March','April','May','June','July','August','September','October','November','December');
                $data['type']= $months[$month_number];
                $this->template->build('dayclosing',$data);
             }

             public function daily_dayclose($id){
                $case="daily_dayclose";
                $datas=$_POST;
                $datas['user_id']=$id;
                $data['dayclose_data']=$this->home->edit_data($datas,$case);
                $data['type']="Datewise Dayclosing Report";
                $data['case']="view_dayclosing";
                $this->template->build('dayclosing',$data);
             }  






           //Bank Module


      public function bank(){
                $data['case']="view";
                $this->template->build('bank',$data);
            }

            public function bank_reports(){
                $data['case']="bankreports";
                $this->template->build('bank_transfer',$data);
            }

            public function bank_individaul_reports($id){
                $data['case']="bank_individaul_reports";
                $data['id']=$id;
                $this->template->build('bank_transfer',$data);
            }

             public function view_bank($id){
                $case="bank";
                $data['bank_data']=$this->home->edit_data($id,$case);
                $data['case']="view_bank";
                $this->template->build('bank',$data);
            }


            public function add_bank(){
                $data['case']="add";
                $this->template->build('bank',$data);
            }

            public function insert_bank(){
                $data=$_POST;
                $case="bank";
                $insert_id=$this->home->add_data($data,$case);
                  if($insert_id){
                    $result=array('result'=>"success",'message'=>'Bank added  successfully');
                  }else{
                        $result=array('result'=>"failed",'message'=>"Something went wrong please try after sometime..");
                  }
             $this->session->set_flashdata('message', $result);
             redirect('home/bank');
       
        }
           
        public function edit_bank($id){
           $case="bank";
           $data['bank_data']=$this->home->edit_data($id,$case);
           $data['case']="edit";
           $this->template->build('bank',$data);
            }



      public function update_bank(){
              $data=$_POST;
              $checkbank =$this->home->editcheckbank($data);

              if($checkbank){
                  $result=array('result'=>"failed",'message'=>"Bank   name already exits ");
                  $this->session->set_flashdata('message', $result);
                  redirect('home/bank');
               }else{
                  $case="bank";
                  $update_id=$this->home->update_data($data,$case);
                       if($update_id){
                            $result=array('result'=>"success",'message'=>'Bank  Updated  successfully');
                        }else{
                            $result=array('result'=>"failed",'message'=>"Something went wrong please try after sometime..");
                        }
              $this->session->set_flashdata('message', $result);
              redirect('home/bank');
            }
        }

        public function checkbank(){
                $bank=trim($this->input->get('bank_name'));
                $this->db->where('bank_slug',url_title($bank));
                $this->db->from(BANK);
                $query = $this->db->get()->row_array();
                      if($query){
                        echo "false";
                      }else{
                        echo "true";
                      }
            }







            //bank transfer

             //Bank Module


      public function bank_transfer(){
                $data['case']="view";
                $this->template->build('bank_transfer',$data);
            }

             public function view_transfer($id){
                $case="transfer";
                $data['transfer_data']=$this->home->edit_data($id,$case);
                $data['case']="view_transfer";
                $this->template->build('bank_transfer',$data);
            }


            public function add_transfer(){
                $data['case']="add";
                $this->template->build('bank_transfer',$data);
            }

            public function insert_transfer(){
                $data=$_POST;
                $case="transfer";
                
                $insert_id=$this->home->add_data($data,$case);

                if (isset($_FILES['payment_ref']) && !empty($_FILES['payment_ref']['name'])) {
                        $fileInfo = pathinfo($_FILES['payment_ref']['name']);
                        $img_name = rand() . '.' . $fileInfo['extension'];
                        $ImageName = $img_name;
                        $path='upload/'.$ImageName;
                        $location = $path; 
                        move_uploaded_file($_FILES['payment_ref']['tmp_name'], $location); 
                        $data_imgs['payment_ref'] = $ImageName;
                        $data_imgs['id'] = $insert_id;
                        $this->home->update_data($data_imgs,$case);
                    }


                  if($insert_id){
                    $result=array('result'=>"success",'message'=>'Bank Transfer added  successfully');
                  }else{
                        $result=array('result'=>"failed",'message'=>"Something went wrong please try after sometime..");
                  }
             $this->session->set_flashdata('message', $result);
             redirect('home/bank_transfer');
       
        }
           
        public function edit_transfer($id){
           $case="transfer";
           $data['transfer_data']=$this->home->edit_data($id,$case);
           $data['case']="edit";

           $this->template->build('bank_transfer',$data);
            }


       
      public function update_transfer(){
              $data=$_POST;
              $old_image =$data['old_payment_ref'];
              unset($data['old_payment_ref']);
                  $case="transfer";
                  $update_id=$this->home->update_data($data,$case);

                   if (isset($_FILES['payment_ref']) && !empty($_FILES['payment_ref']['name'])) {
                        unlink('upload/'.$old_image);
                        $fileInfo = pathinfo($_FILES['payment_ref']['name']);
                        $img_name = rand() . '.' . $fileInfo['extension'];
                        $ImageName = $img_name;
                        $path='upload/'.$ImageName;
                        $location = $path; 
                        move_uploaded_file($_FILES['payment_ref']['tmp_name'], $location); 
                        $data_imgs['payment_ref'] = $ImageName;
                        $data_imgs['id'] = $data['id'];
                        $this->home->update_data($data_imgs,$case);
                    }
                       if($update_id){
                            $result=array('result'=>"success",'message'=>'Bank Transfer  Updated  successfully');
                        }else{
                            $result=array('result'=>"failed",'message'=>"Something went wrong please try after sometime..");
                        }
              $this->session->set_flashdata('message', $result);
              redirect('home/bank_transfer');
           
        }

        public function get_expence_total(){
          $tickets = $this->home->get_expence_total();

          $s=1;
          foreach ($tickets as $key => $value) {
              $tic_data[$s]=$value;
         $s++; }
         
          $year=date('Y'); $month=date('m');

          $totaldays = cal_days_in_month(CAL_GREGORIAN,$month,$year);


          $date=array();
          for($i=1; $i <= $totaldays; $i++){
              $time=mktime(12, 0, 0, $month, $i, $year);          
              if (date('m', $time)==$month)       
                  $date[$i]=date('d', $time);
                 
          }


         
         for ($i=1; $i <= count($tic_data) ; $i++) { 
               $tic = explode('-', $tic_data[$i]['date']);
               $tivv[$i] =$tic[2];
               $exp_data[$tic[2]]=$tic_data[$i];
         }
       
           $data=array();
              for ($i=1; $i <=$totaldays; $i++){ 
               
            if (in_array($date[$i],$tivv)) { 
            
                  $val['expence_name']=$exp_data[$i]['expence_name'];
                    $val['cost']=$exp_data[$i]['cost'];
                    $val['date']=$date[$i];
                    $data[] = $val;
              }else{ 
               
                    $values['expence_name']=0;
                    $values['cost']=0;
                    $values['date']=$date[$i];
                    $data[] = $values;
              }
            }

           $data['days'] = $totaldays;
           
         echo json_encode($data);
        }

        public function get_total_ticket(){
          $date=date('Y-m-d');
          $this->db->select('A.*,B.product_name,C.name,C.work_location');
          $this->db->from(BILL.' A');
          $this->db->join(PRODUCTS. ' B', 'B.id=A.product_name', 'left');
          $this->db->join(LOGIN. ' C', 'C.user_id=A.user_id', 'left');
          $this->db->where('A.date ',$date);
          $today_billing=$this->db->get()->result_array();
          for ($i=0; $i <count($today_billing) ; $i++) { 
             $final[]=array("label"=>strtoupper($today_billing[$i]['product_name']), "y"=>$today_billing[$i]['ticket'],"z"=>$today_billing[$i]['ticket_cost']);
          }
       
          echo json_encode($final);
        }

         //Location section

            public function location(){
                $data['case']="view";
                $this->template->build('location',$data);
            }

             public function view_location($id){
                $case="location";
                $data['location']=$this->home->edit_data($id,$case);
                $data['case']="view_location";
                $this->template->build('location',$data);
            }


            public function add_location(){
                $data['case']="add";
                $this->template->build('location',$data);
            }


            public function checklocation(){
                $location=$this->input->get('location');
                $this->db->where('location_slug',trim(url_title($location)));
                $this->db->from(LOCATION);
                $query = $this->db->get()->row_array();
                    if($query){
                      echo "false";
                    }else{
                      echo "true";
                    }
            }


            public function insert_location(){
                $data=$_POST;
                $case="location";
                $insert_id=$this->home->add_data($data,$case);

                        if($insert_id){
                              $result=array('result'=>"success",'message'=>'Location added  successfully');
                        }else{
                              $result=array('result'=>"failed",'message'=>"Something went wrong please try after sometime..");
                        }
             $this->session->set_flashdata('message', $result);
             redirect('home/location');
       
        }
           


           public function edit_location($id){
           $case="location";
           $data['location']=$this->home->edit_data($id,$case);
           $data['case']="edit";
           $this->template->build('location',$data);
            }

            public function update_location(){
              $data=$_POST;
              $checklocation=$this->home->editchecklocation($data);

              if($checklocation){
                  $result=array('result'=>"failed",'message'=>"Location   name already exits ");
                  $this->session->set_flashdata('message', $result);
                  redirect('home/location');
               }else{
                  $case="location";
                  $update_id=$this->home->update_data($data,$case);
                     if($update_id){
                          $result=array('result'=>"success",'message'=>'Location  Updated  successfully');
                      }else{
                          $result=array('result'=>"failed",'message'=>"Something went wrong please try after sometime..");
                      }
              $this->session->set_flashdata('message', $result);
              redirect('home/location');
            }
        }


        //expence approval


         public function expence_approve_view(){
                $this->template->build('expence_approve',$data);
            }

            
            public function approve_expence($id){
                $this->db->select_max('ref_number');
				$this->db->from(EXPENCE_COST);
				$ref = $this->db->get()->row_array();

                $ref_number = explode('-',$ref['ref_number']);

             
                
                if($ref_number==""){
                       $number ="001";
                    }elseif($ref_number[2] < 10){
                         $number =str_pad($ref_number[2]+1, 3, '0', STR_PAD_LEFT);
                    }elseif($ref_number > 10){
                          $number =str_pad($ref_number[2]+1, 3, '0', STR_PAD_LEFT);
                    }elseif($ref_number >100 ){
                          $number =$ref_number[2]+1;
                } 
               /*if($old_ref['status']==2){
                    $data['status']=1;
                    $data['ref_number']=$old_ref['ref_number'];
                    $this->db->where('id',$id);
                    $update = $this->db->update(EXPENCE_COST,$data);
                    
               }else{*/
                    $data['status']=1;
                    $data['ref_number']=date("Y-m-").$number;
                    $this->db->where('id',$id);
                    $update = $this->db->update(EXPENCE_COST,$data);
              // }
                
                      if($update){
                        $result=array('result'=>"success",'message'=>'Expence approved  successfully');
                      }else{
                            $result=array('result'=>"failed",'message'=>"Something went wrong please try after sometime..");
                      }
             $this->session->set_flashdata('message', $result);
             redirect('home/expence_approve_view');
       
        }
           
        public function cancel_expence($id){
                    $this->db->where('id',$id);
                    $update = $this->db->delete(EXPENCE_COST);
               
                      if($update){
                        $result=array('result'=>"success",'message'=>'Expence deleted  successfully');
                      }else{
                            $result=array('result'=>"failed",'message'=>"Something went wrong please try after sometime..");
                      }
             $this->session->set_flashdata('message', $result);
             redirect('home/expence_approve_view');
            }

            public function viewall($value){
              $data['case']=$value;
              $this->template->build('all_ticktes',$data);
            }


            //Admin Expence

            //Expence Module

            public function admin_expence(){
                $data['case']="view";
                $this->template->build('admin_expence',$data);
            }

             public function view_admin_expence($id){
                $case="admin_expence";
                $data['case']="view_expence";
                $this->template->build('admin_expence',$data);
            }


            public function add_admin_expence(){
                $data['case']="add";
                $this->template->build('admin_expence',$data);
            }
            



            public function insert_admin_expence(){
                $data=$_POST;
                $case="admin_expence";
                $insert_id=$this->home->add_data($data,$case);
                  if($insert_id){
                    $result=array('result'=>"success",'message'=>' Expence added  successfully');
                  }else{
                        $result=array('result'=>"failed",'message'=>"Something went wrong please try after sometime..");
                  }
             $this->session->set_flashdata('message', $result);
             redirect('home/admin_expence');
       
           }
           
              public function edit_admin_expence($id){
                 $case="admin_expence";
                 $data['expence_data']=$this->home->edit_data($id,$case);
                 $data['case']="edit";
                 $this->template->build('admin_expence',$data);
                  }


              public function delete_admin_expence($id){
                $this->db->where('id',$id);
                $delete_billing = $this->db->delete(EXPENCE);
                    if($delete_billing){
                        $result=array('result'=>"success",'message'=>"Expence deleted successfully");
                    }else{
                        $result=array('result'=>"failed",'message'=>"Something went wrong please try after sometime..");
                    }
                 $this->session->set_flashdata('message', $result);
                 redirect('home/admin_expence');
            }


             public function total_sales(){
                $this->template->build('total_sales');
            }

              public function edit_billing(){
              	$data['case']="all";
                $this->template->build('billing_edit',$data);
              }

              public function location_bill(){
              	$case="location_bill";
              	$location = $_POST['location'];
              	$data['location_bill']=$this->home->edit_data($location,$case);
              	$data['case']="location";
                $this->template->build('billing_edit',$data);
              }

              public function date_bill(){
              	$case="date_bill";
              	$date = $_POST['start_date'];
              	$data['date_bill']=$this->home->edit_data($date,$case);
              	$data['case']="date_bill";
                $this->template->build('billing_edit',$data);
              }

              public function bill_edit($id){
              	$this->db->where('id',$id);
              	$query = $this->db->from(BILL)->get()->row_array();
              	//get location wise products
              	$this->db->select('B.*');
              	$this->db->from(LOGIN.' A');
              	$this->db->join(PRODUCTS.' B','B.location=A.work_location','left');
              	$this->db->where('A.user_id',$query['user_id']);
              	$products=$this->db->get()->result_array();
              	
              	$case="bill_edit";
              	$data['bill_edit']=$this->home->edit_data($id,$case);
              	$data['products']=$products;
              	$data['case']="bill_edit";
                $this->template->build('billing_edit',$data);
              }

              public function update_bill(){
              	
              	$explode=explode('^',$_POST['product_name']);
                $_POST['product_name']=$explode[0];
                $_POST['ticket_cost']=$explode[1] * $_POST['ticket'];
              	$case = "update_bill";
              	$update_bill = $this->home->update_data($_POST,$case);
              	if($update_bill){
              		$result =array("result"=> "success","message"=>"Bill updated successfully");
              	}else{
              		$result =array("result"=> "failed","message"=>"Oops ! failed");
              	}
              	echo json_encode($result);
              }


              public function dayclose_edit(){
              	$data['case']="all";
              	$this->template->build('dayclose_edit',$data);
              }

              public function location_close(){
              	$case="location_close";
              	$location = $_POST['location'];
              	$data['location_close']=$this->home->edit_data($location,$case);
              	$data['case']="location";
                $this->template->build('dayclose_edit',$data);
              }


              public function date_close(){
              	$case="date_close";
              	$location = $_POST['start_date'];
              	$data['date_close']=$this->home->edit_data($location,$case);
              	$data['case']="date_close";
                $this->template->build('dayclose_edit',$data);
              }


              public function expence_adminview(){
              	$data['case']="all";
              	$this->template->build('expence_edit',$data);
              }

              public function location_expence(){
              	$case="location_expence";
              	$location = $_POST['location'];
              	$data['location_expence']=$this->home->edit_data($location,$case);
              	$data['case']="location";
                $this->template->build('expence_edit',$data);
              }


              public function date_expence(){
              	$case="date_expence";
              	$location = $_POST['start_date'];
              	$data['date_expence']=$this->home->edit_data($location,$case);
              	$data['case']="date";
                $this->template->build('expence_edit',$data);
              }

              public function profile_edit(){
                $this->template->build('profile');
              }

              public function update_profile(){
                $case ="admin_profile";
               $update_profile =$this->home->update_data($_POST,$case);
               if($update_profile){
                  $result =array("result"=> "success","message"=>"Profile updated successfully");
               }else{
                   $result=array('result'=>"failed",'message'=>"Something went wrong please try after sometime..");
               }
               $this->session->set_flashdata('message', $result);
               redirect('home/profile_edit');
              }


              public function daily_transfer($id){
                $case="date_transfer";
                $vale['date'] = $_POST['start_date'];
                $vale['id'] = $id;
                $data['getbank']=$this->home->edit_data($vale,$case);
                $data['case']="bank_individaul_reports";
                $this->template->build('bank_transfer',$data);
              }

              public function week_transfer($id){
                $case="week_transfer";
                $week['start_date'] = $_POST['start_date'];
                $week['end_date'] = $_POST['end_date'];
                $week['id'] = $id;
                $data['getbank']=$this->home->edit_data($week,$case);
                $data['case']="bank_individaul_reports";
                $this->template->build('bank_transfer',$data);
              }


              public function allreport(){
                $this->template->build('allreport');
              }
            /*  public function month_pdf(){
                $data['month']=$_POST['month'];
                $html=$this->load->view('pdf_data.php', $data, true);
                $pdfFilePath = "output_pdf_name.pdf";
                $this->load->library('m_pdf');
                 $this->load->library('m_pdf');
                $this->m_pdf->pdf->WriteHTML($html);
                $this->m_pdf->pdf->Output($pdfFilePath, "D");
              }*/


              public function pdf_report(){
                $pdf['data'] = $_POST;
                $html=$this->load->view('pdf_data.php',$pdf, true);
                $pdfFilePath = "output_pdf_name.pdf";
                $this->load->library('m_pdf');
                $this->m_pdf->pdf->WriteHTML($html);
                $this->m_pdf->pdf->Output($pdfFilePath, "D");
              }


              /*public function cron_job(){
                      $location =get_location();
                      foreach ($location as  $value) { 
                          $set_bal['open_balance'] = get_opening_balance($value['id'],"controller");
                          $set_bal['date'] = date('Y-m-d');
                          $set_bal['location']=$value['id'];
                          $set_bal['time']=date('H:i:s');
                          $date_end = date('Y-m-d', strtotime('last day of this  month'));
                          if($date_end==$set_bal['date']){
                            $this->db->insert(OPEN_BALANCE,$set_bal);
                            $data = $this->db->insert_id();
                          }
                    }
              }*/

            public function open_balance(){
                $data['case']="add";
                $this->template->build('open_balance',$data);
            }

             public function edit_openbal($id){
                $case="open_balance";
                $datas['edit_bal'] = $this->home->edit_data($id,$case);
                $datas['case'] ="edit";
                $this->template->build('open_balance',$datas);
            }

            public function viewopen_balance(){
                $data['case']="view";
                $this->template->build('open_balance',$data);
            }

            public function insert_openbal(){
                $case="openbal";
                $checkbal = $this->home->check_openbalance($_POST);
                if($checkbal){
                	$result =array("result"=> "failed","message"=>"Openbalance  already enter for this Location ");
                }else{
                	$open = $this->home->add_data($_POST,$case);
                    if($open){
                        $result =array("result"=> "success","message"=>"Openbalance added successfully");
	                }else{
	                   $result=array('result'=>"failed",'message'=>"Something went wrong please try after sometime..");
	                }
                }
               $this->session->set_flashdata('message', $result);
               redirect('home/viewopen_balance');
            }

            public function update_openbal(){
            	$this->db->where('id',$_POST['id']);
            	$update = $this->db->update(OPEN_BALANCE,$_POST);
            	if($update){
            		 $result =array("result"=> "success","message"=>"Openbalance Updated successfully");
            	}else{
	                   $result=array('result'=>"failed",'message'=>"Something went wrong please try after sometime..");
	                }
               $this->session->set_flashdata('message', $result);
               redirect('home/viewopen_balance');
            }

}    


